/**
 * 定义被观察者 - 老师
 */
class Teacher {
  constructor() {
    this.patriarchs = []; // 家长们（观察者）, patriarch: 家长
  }

  // 添加观察者
  addPatriarch(patriarch) {
    this.patriarchs.push(patriarch);
  }
  removePatriarch(patriarch) {
    this.patriarchs.forEach((item, i) => {
      if (item.name === patriarch.name) {
        this.patriarchs.splice(i, 1);
      }
    });
  }

  // 通知功能
  notify() {
    this.patriarchs.forEach((patriarch) => {

      // 模拟老师正确通知给家长了 
      console.log(`通知给${patriarch.name}了！`);

      // 执行家长行为
      patriarch.action();
    });
  }
}

/**
 * 观察者 - 家长
 */
class Patriarch {
  constructor(name) {
    this.name = name;
  }

  // 家长回复行为，通过打印模拟家长收到通知
  action() {
    console.log(`${this.name}收到老师的通知了！`);
  }
}


// 1、创建发布者
const teacher = new Teacher();

// 2、并添加观察者
teacher.addPatriarch(new Patriarch("小明家长"));
teacher.addPatriarch(new Patriarch("张三家长"));
teacher.addPatriarch(new Patriarch("李雷家长"));

// 3、执行通知发布
teacher.notify();
